/*
 * Copyright (c) 1993-2012 David Gay
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose, without fee, and without written agreement is hereby granted,
 * provided that the above copyright notice and the following two paragraphs
 * appear in all copies of this software.
 *
 * IN NO EVENT SHALL DAVID GAY BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF DAVID GAY HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * DAVID GAY SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND DAVID
 * GAY HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 * ENHANCEMENTS, OR MODIFICATIONS.
 */

| srcdir |
if (INTBITS != 63) error(error_bad_value);
srcdir = dirname(loading_file()) + "/";

trap_error(fn() [
  | slice, slices |
  slice = 0;
  slices = 1;

  // optional (N . M) in 'build_slice' picks the N'th out of
  // M subsets of files to compile
  if (build_slice != null)
    @(slice . slices) = build_slice;

  mc:verbose = 0;
  mp:reset_counters();
  start = ctime();

  safecomp = fn (s)
    if (!pcompile(s))
      [
        display("Failed!\n");
        quit(1)
      ];

  | mfiles |
  // sort by size
  mfiles = vmap(fn (f) [ f += ".mud"; f . file_stat(srcdir + f)[fs_size] ], '[
    ,("a" + mc:archname)
    "compile"
    "compiler"
    "dihash"
    "dlist"
    "flow"
    ,("gen" + mc:archname)
    "graph"
    "inference"
    "ins3"
    "link"
    "misc"
    ,("m" + mc:archname)
    "noinf"
    "optimise"
    "phase1"
    "phase2"
    "phase3"
    "phase4"
    "sequences"
    "vars"
    ,mc:archname
  ]);
  vqsort!(fn (a, b) cdr(a) > cdr(b), mfiles);

  for (| n | n = slice; n < vlength(mfiles); n += slices)
    safecomp(srcdir + car(mfiles[n]));

  if (silent != true)
    [
      dformat("cpu time: %s ms%n", ctime() - start);
      dformat("nins:   %s%n", mc:nins);
      dformat("nbytes: %s%n", mc:nbytes);
    ]
], fn (n) [
  quit(1);
], call_trace_on, null);
