/*
 * Copyright (c) 1993-2012 David Gay and Gustav Hllberg
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose, without fee, and without written agreement is hereby granted,
 * provided that the above copyright notice and the following two paragraphs
 * appear in all copies of this software.
 *
 * IN NO EVENT SHALL DAVID GAY OR GUSTAV HALLBERG BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF DAVID GAY OR
 * GUSTAV HALLBERG HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * DAVID GAY AND GUSTAV HALLBERG SPECIFICALLY DISCLAIM ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
 * "AS IS" BASIS, AND DAVID GAY AND GUSTAV HALLBERG HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#ifndef RUNTIME_LIST_H
#define RUNTIME_LIST_H

#include "../types.h"
#include "../utils.h"

void list_init(void);

value code_set_carb(struct list *l, value x);
value code_set_cdrb(struct list *l, value x);

value code_car(struct list *l);
value code_cdr(struct list *l);

static inline struct list *mudlle_reverse_list(struct list *l)
{
  return reverse_list_ofs(l, offsetof(struct list, cdr));
}

/* check that 'l' is a list with at most MAX_VECTOR_SIZE elements, and that
   each entry is of a type in 'typeset' */
enum runtime_error check_proper_list(struct list *l, typeset_t typeset,
                                     size_t *elems, const char **errmsg);

#endif /* RUNTIME_LIST_H */
